#!/usr/bin/perl
#written by Sante Nocciolino 26/06/2013
#version 0.2
#proxy trasparente su Dlink DSL-2640B
#todo: parametrizzare username, password, netmask, routerip

use Net::Telnet;
use Switch;

my $action='';
my $router='192.168.1.1';
my $proxy='';

if ($#ARGV<0) { 
print  "USAGE: proxy.pl [-reset] [-remove] proxyip\n";
exit;
}

if ($ARGV[0]!='-reset') {
	$proxy=$ARGV[0];
} else {
	$action=$ARGV[0];
	$proxy=$ARGV[1];
}

$telnet = new Net::Telnet ( Timeout=>60);
$telnet->open($router);
$telnet->waitfor('/BCM96348 ADSL Router/');
print "ADSL router riconosciuto!\n";
$telnet->waitfor('/Login: ?$/i');
$telnet->print('admin');
$telnet->waitfor('/Password: ?$/i');
$telnet->print('admin');

## Switch to a known shell, using a known prompt.
$telnet->prompt('/> $/');

switch ($action) {
	case "-reset" {
		$telnet->errmode("return");
		print "L'operazione richiede circa 60 secondi!\n";
		$telnet->cmd('reboot');
		print "Proxy trasparente rimosso dal router!\n";
	}
	case "-remove" {
		$telnet->cmd("iptables -t nat -D PREROUTING -i br0 -s 192.168.1.0/24 -d 192.168.1.0/24 -p tcp --dport 80 -j ACCEPT");
		$telnet->cmd("iptables -t nat -D PREROUTING -i br0 -s ! $proxy -p tcp --dport 80 -j DNAT --to $proxy:3128");
		$telnet->cmd("iptables -t nat -D POSTROUTING -o br0 -s 192.168.1.0/24 -d $proxy -p tcp -j SNAT --to $router");
		$telnet->cmd("iptables -D FORWARD -i br0 -o br0 -s 192.168.1.0/24 -d $proxy -p tcp --dport 3128 -j ACCEPT");
		print "Proxy trasparente impostato sul router!\n";
	}
	else {
		$telnet->errmode("die");
		@tables=$telnet->cmd('iptables --list');
		my $found=0;
		foreach (@tables) {
			$search=index $_,":3128";
			if ($search!=-1) {
 				++$found;
			} 
		}
		if ($found) {
			print "OK, sembra che non ci sia nulla da fare!\n"
		} else {
			$telnet->cmd("iptables -t nat -A PREROUTING -i br0 -s 192.168.1.0/24 -d 192.168.1.0/24 -p tcp --dport 80 -j ACCEPT");
			$telnet->cmd("iptables -t nat -A PREROUTING -i br0 -s ! $proxy -p tcp --dport 80 -j DNAT --to $proxy:3128");
			$telnet->cmd("iptables -t nat -I POSTROUTING -o br0 -s 192.168.1.0/24 -d $proxy -p tcp -j SNAT --to $router");
			$telnet->cmd("iptables -I FORWARD -i br0 -o br0 -s 192.168.1.0/24 -d $proxy -p tcp --dport 3128 -j ACCEPT");
			print "Proxy trasparente impostato sul router!\n";
		}
	} #end switch else
} #end switch

print "Finito!\n"
